<?php
/**
 * Template Name: New construction insulation
 *
 * Template for displaying the homepage with hero banner.
 */

get_header();
?>

  <div class="overlay"></div>
  <section class="hero-banner bleed-container">
      <div class="hero-content">
        <h1>CrawlSpace Innovations <br><span class="tri-theme-color">New Jersey’s Premier </span>New Construction Insulation Experts</h1>
        <a href="#" class="btn-quote">GET A QUOTE</a>
      </div>
      <!-- <div class="hero-featured-content">
        <div>
          <p><span>Featured</span></p>
        </div>
        <div>
          <p>Austin, Texas</p>
          <strong>MetLife Corporate Space</strong>
        </div>
      </div> -->
  </section>
</div>


<!-- <div class="ast-container home-page"> -->
<section class="left-image-sec global-margin">
  <div class="container-boxed">      
    <div>
      <img src="<?php echo get_site_url();?>/wp-content/uploads/2025/07/services-sub-section-image.webp" alt="">
    </div>
    <div>
      <h2 class="large-heading">Insulation Solutions  <br></h2><p class="small-fnt">That Set Your Home Up for Success.</p>
      <p>
      At CrawlSpace Innovations, LLC we work side-by-side with homeowners, builders, and general contractors to design and install insulation that performs from day one - delivering comfort, efficiency, and peace of mind for decades to come.
      </p>
      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
  </div>
</section>

<!-- </div> -->

<section class="service-details global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h4 class="quote-heading">OUR SERVICES</h4>
        <h3 class="large-heading">Custom Insulation Services for New Construction in New Jersey</h3>
        <p class="sub-heading">Make Insulation a Priority Before the Drywall Goes Up</p>
        <p>
          Planning insulation during the design phase is quicker, cleaner, and far more economical than retrofitting later. With our experience of serving the Ocean County area of New Jersey for more than 20 years, we can seamlessly integrate our solutions into any blueprint:
        </p>
      </div>
      <div class="table-config">
        <table style="width:100%;border: none;font-family: 'Poppins', sans-serif;">
          <thead>
            <tr style="background-color: #1456AD; color: white;">
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Solution</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Ideal For</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Key Advantages</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Closed-Cell Spray Foam</td>
              <td style="padding: 12px;">Foundations, rim joists, roofs</td>
              <td style="padding: 12px;">Highest R-value per inch, vapor barrier, structural strength</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Open-Cell Spray Foam</td>
              <td style="padding: 12px;">Interior walls, vaulted ceilings</td>
              <td style="padding: 12px;">Cost-effective air sealing, sound damping</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Dense-Pack Cellulose</td>
              <td style="padding: 12px;">Walls, cathedral ceilings</td>
              <td style="padding: 12px;">Recycled content, excellent sound control, tight fit around wiring</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Blown-In Fiberglass</td>
              <td style="padding: 12px;">Attics, bonus rooms</td>
              <td style="padding: 12px;">Budget-friendly, quick install, great coverage</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Hybrid Systems</td>
              <td style="padding: 12px;">Custom builds needing ultra-high R-values</td>
              <td style="padding: 12px;">Combines foam + batts for best of both worlds</td>
            </tr>
          </tbody>
        </table>
      </div>
      <p class="text-center"><i>Future-proof your property today!</i></p>
    </div>
</section>

<section class="image-slider-sec global-margin content-section-box">
    <div class="container-boxed">
        <div class="text-center">
          <h3 class="large-heading">Why Hire CrawlSpace Innovations in New Jersey?</h3>
          <p class="sub-heading">Before and After Results You Can See and Feel</p>
        </div>
        <div class="slider-image">
          <main>
            <div class="container">
              <div class="image-container">
                <img
                  class="image-before slider-image"
                src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/home-hero-banner.webp"
                  alt="color photo"
                />
                <img
                  class="image-after slider-image"
                  src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/service-bg.webp"
                  alt="black and white"
                />
              </div>
              <!-- step="10" -->
              <input
                type="range"
                min="0"
                max="100"
                value="50"
                aria-label="Percentage of before photo shown"
                class="slider"
              />
              <div class="slider-line" aria-hidden="true"></div>
              <div class="slider-button" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" viewBox="0 0 256 256">
                  <rect width="256" height="256" fill="none"></rect>
                  <line x1="128" y1="40" x2="128" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <line x1="96" y1="128" x2="16" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></line>
                  <polyline points="48 160 16 128 48 96" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></polyline>
                  <line x1="160" y1="128" x2="240" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <polyline points="208 96 240 128 208 160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></polyline>
                </svg>
              </div>
            </div>
          </main>
        </div>
        <div class="grey-area">
          
          <h5 class="text-center">What Sets Us Apart</h5>
          <div class="why-choose-cards">
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
              <h4>Carefully Crafted Work</h4>
              <p>Only top-notch, code-compliant installs, no shortcuts</p>
            </div>

            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
              <h4>Complete Transparency</h4>
              <p>Without any pressure or technical terms, we guide you through each decision.</p>
            </div>

            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
              <h4>Long-Term Results</h4>
              <p>Our insulation is made to last for decades, not just this season</p>
            </div>

            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
              <h4>Heartfelt Care</h4>
              <p>Do you require direction? We are pleased to offer consultations as well as sales.</p>
            </div>
          </div>
        </div>
    </div>
</section>

<section class="new-accordians global-margin">
    <div class="container-boxed">
      <div>
        <h4 class="quote-heading">OUR SERVICES</h4>
        <h3 class="large-heading">CrawlSpace Innovations, LLC Insulates Where It Matters the Most</h3>
        <p class="sub-heading">Insulation is the best strategy for your entire house, not just one room. Here’s where installing it during the build can be useful:</p>
      </div>
      <div class="accordion">

        <div class="accordion-item">
          <button class="accordion-header">01 &nbsp;&nbsp; Attics <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            The roof accounts for up to 25% of warmth loss. Before it leaks, make sure it’s tightly sealed.
            </p>
            <!-- <a class="yello-btn" href="">Get a quote</a> -->
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">02 &nbsp;&nbsp; Crawlspaces <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>These are essential for controlling moisture and stopping temperature loss from uninsulated flooring.</p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">03 &nbsp;&nbsp; External walls <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            Essential for energy conservation and temperature management. From the beginning, we pack them effectively.
            </p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">04 &nbsp;&nbsp; Interior Walls <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            Desire seclusion and peace of mind? Room-to-room noise is also decreased by interior insulation.
            </p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">05 &nbsp;&nbsp; Windows & Doors <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            We caulk gaps around frames to keep bugs, drafts, and moisture out.
            </p>
          </div>
        </div>
        <p class="text-center">Worried about the new construction insulation costs in different areas of the house? Don’t be! We will surely consider your financial burden. Talk to us and we can discuss your finances accordingly. Give us a call today!</p> 
      </div>
    </div>
</section>

<section class="innovation-sec global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h3 class="large-heading">Insulation That Sets the Stage for a Comfortable Future</h3>
        <!-- <p class="sub-heading">Expertise, Quality & a Hassle-Free Experience from Start to Finish</p> -->
      </div>
      <div class="check-box">
        <!-- <p class="text-center">Here’s what makes choosing us the smarter move:</p> -->
        <ul>
          <li>Easily comply with local building codes</li>
          <li>100% Reduce Future Energy Costs by Keeping Air Conditioning in</li>
          <li>Completely sealing crawl spaces, walls, and attics will help avoid headaches in the future.</li>
          <li>Increase the Value of Your Property with Energy-Smart Features</li>
          <li>Guarantee Year-Round Comfort Right Away</li>
        </ul>
      </div>
      <p class="text-center">Convinced yet? Start taking insulation in new constructions seriously.</p>
    </div>
</section>

<section class="right-image-sec global-margin">
    <div class="container-boxed">
      <div>
        <h2 class="large-heading">Our Process</h2>

        <h4>Design Consultation</h4>
        <p>
        We review plans, energy goals, and code requirements.
        </p>

        <h4>Material Selection</h4>
        <p>We recommend the optimal insulation type, thickness, and air-sealing strategy.</p>

        <h4>Professional Installation </h4>
        <p>Certified crews install on your schedule, coordinating with other trades to avoid delays.</p>

        <h4>Final Inspection & Warranty </h4>
        <p>We walk the job with you, handle the paperwork, and back every project with a written guarantee.</p>

        <p><i>You deserve superior insulation for your building. Set up a site tour for today, and let's make it happen.</i></p>
      </div>
      <div>
        <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/image-right.webp" alt="">
      </div>
    </div>
</section>

<section class="left-image-sec global-margin">
  <div class="container-boxed">      
    <div>
      <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/services-sub-section-image.webp" alt="">
    </div>
    <div>
      <h2 class="large-heading">Build Smarter 
      <br></h2><p class="small-fnt">With Expert New Construction Insulation in New Jersey </p>
      <p>
      CrawlSpace Innovations, LLC is a leading local company serving the Ocean County area of New Jersey for more than 20 years. We prioritize durability, comfort, and energy economy.
      </p>

      <p>
      We guarantee that every square inch of your new construction is safe and prepared for the future by bringing years of experience, premium materials, and proven processes to your project.
      </p>

      <p>
      We have the resources, personnel, and expertise to properly insulate any type of building, whether it be a commercial building, a multi-unit complex, or a custom house.
      </p>

      <p>
        <i>Contact CrawlSpace Innovations, LLC now, and together, let’s insulate your home for now and the future.</i>
      </p>

      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
  </div>
</section>

<section class="faq-sec global-margin">
  <div class="container-boxed">
      <div class="text-center">
        <h2 class="large-heading">FAQs</h2>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Why is insulation important in new construction?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer active">
          <p class="answer-text">Proper insulation ensures energy efficiency, indoor comfort, and full code compliance from the start.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">When is the best time to install insulation during a new build in New Jersey?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">New Construction Insulation in New Jersey should be installed after framing, plumbing, and electrical work, but before drywall.</p>
        </dd>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">What types of insulation do you offer for new builds?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">We offer spray foam, blown-in fiberglass, dense-pack cellulose, and hybrid systems.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Can you work with my builder or contractor?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Yes, we regularly coordinate with builders and site managers to stay on schedule.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Do you follow New Jersey building codes?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Absolutely. We stay current with all NJ insulation codes and provide full compliance documentation.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">How do I get started?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Click “Get a Quote” to schedule a free consultation and review your building plans.</p>
        </dd>
      </div>
  </div>
</section>

<div class="ast-container home-page">
  <section class="contact-us bleed-container">
    <div>
      <div class="contact-info">
        <div class="contact-info-content">
          <h2>Start Your Insulation or Crawlspace Project Today</h2>
          <p>Fill out the form and we will respond within 24 hours of your request.</p>
        </div>
        <div class="contact-info-banner">
          <div>
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-banner.png" alt="">
          </div>
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-filler.png" alt="">
        </div>
      </div>
      <div class="contact-form"> <?php echo do_shortcode( '[contact-form-7 id="fc93547" title="Home Contact Form"]' ); ?></div>
    </div>
  </section>

<script>


</script>

<?php
get_footer();
?>