<?php
/**
 * Template Name: Renovation insulation
 *
 * Template for displaying the homepage with hero banner.
 */

get_header();
?>

  <div class="overlay"></div>
  <section class="hero-banner bleed-container">
      <div class="hero-content">
        <h1>Your Trusted <span class="tri-theme-color">Home Renovation Insulation</span> Partners in NJ</h1>
        <a href="#" class="btn-quote">GET A QUOTE</a>
      </div>
      <!-- <div class="hero-featured-content">
        <div>
          <p><span>Featured</span></p>
        </div>
        <div>
          <p>Austin, Texas</p>
          <strong>MetLife Corporate Space</strong>
        </div>
      </div> -->
  </section>
</div>


<!-- <div class="ast-container home-page"> -->
<section class="left-image-sec global-margin">
  <div class="container-boxed">      
    <div>
      <img src="<?php echo get_site_url();?>/wp-content/uploads/2025/07/services-sub-section-image.webp" alt="">
    </div>
    <div>
      <h2 class="large-heading">Upgrade Your Home </h2><p class="small-fnt">With Expert Renovation Insulation</p>

        <p>
        CrawlSpace Innovations, LLC is your trusted partner for all things insulation. Renovating your house with the proper insulation is a contemporary addition that can significantly improve your older house's comfort, energy efficiency, and air quality. 
        </p>
        <p>
        There should be more than simply aesthetic improvements made to your home makeover. Adding or improving insulation during the process ensures long-term performance, energy savings, and indoor comfort.
        </p>
        <p>
        While renovation insulation is one of our best offerings, we do not limit ourselves there. Our services go a little beyond.
        </p>

      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
  </div>
</section>

<!-- </div> -->

<section class="service-details global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h4 class="quote-heading">OUR SERVICES</h4>
        <h3 class="large-heading">Smart Insulation Services for Smarter Renovations</h3>
        <!-- <p class="sub-heading">Built for Every Space & Every Stage</p> -->
      </div>
      <div class="table-config">
        <table style="width:100%;border: none;font-family: 'Poppins', sans-serif;">
          <thead>
            <tr style="background-color: #1456AD; color: white;">
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Insulation Services Offered</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Ideal For</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Why Should You Consider?</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Attic Insulation</td>
              <td style="padding: 12px;">Homes with drafty top floors</td>
              <td style="padding: 12px;">Retains warmth in winters and cool air in summers</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Wall insulation</td>
              <td style="padding: 12px;">Old homes with poor thermal seal</td>
              <td style="padding: 12px;">Helps regulate temperature and improves efficiency</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Crawl space insulation</td>
              <td style="padding: 12px;">Damp or unsealed spaces</td>
              <td style="padding: 12px;">Blocks moisture, pests, and heat loss</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Renovation insulation</td>
              <td style="padding: 12px;">Partial or full home insulation</td>
              <td style="padding: 12px;">Enhances comfort without any major structural changes</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
</section>

<section class="image-slider-sec global-margin content-section-box">
    <div class="container-boxed">
        <div class="text-center">
          <h3 class="large-heading">What Areas Typically Need Insulation During a Renovation?</h3>
          <p class="sub-heading">In older or previously remodeled homes, many trouble spots are overlooked. Insulation is most frequently required in the following areas for better energy efficiency and comfortable homes. Here is how you can know if you really need it.</p>
        </div>
        <div class="slider-image">
          <main>
            <div class="container">
              <div class="image-container">
                <img
                  class="image-before slider-image"
                src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/home-hero-banner.webp"
                  alt="color photo"
                />
                <img
                  class="image-after slider-image"
                  src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/service-bg.webp"
                  alt="black and white"
                />
              </div>
              <!-- step="10" -->
              <input
                type="range"
                min="0"
                max="100"
                value="50"
                aria-label="Percentage of before photo shown"
                class="slider"
              />
              <div class="slider-line" aria-hidden="true"></div>
              <div class="slider-button" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" viewBox="0 0 256 256">
                  <rect width="256" height="256" fill="none"></rect>
                  <line x1="128" y1="40" x2="128" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <line x1="96" y1="128" x2="16" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></line>
                  <polyline points="48 160 16 128 48 96" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></polyline>
                  <line x1="160" y1="128" x2="240" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <polyline points="208 96 240 128 208 160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></polyline>
                </svg>
              </div>
            </div>
          </main>
        </div>
        <div class="grey-area">
          <!-- <p class="text-center">At CrawlSpace Innovations, LLC, we specialize in transforming neglected crawl spaces into clean, efficient, and supportive parts of your home.</p> -->
          <!-- <h5 class="text-center">What Sets Us Apart</h5> -->
          <div class="why-choose-cards">
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
              <p>Air-leaking rafters and attics</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-2.png" alt="">
              <p>Crawl spaces and basements that attract moisture</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-3.png" alt="">
              <p>Low or nonexistent insulation on walls</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-4.png" alt="">
              <p>Floors above patios or garages without heat</p>
            </div>
          </div>
        </div>
    </div>
</section>

<section class="right-image-sec global-margin with-sml-head">
    <div class="container-boxed">
      <div>
        <h2 class="large-heading">Our Services to Help </h2><p class="small-fnt">With Your Renovation Insulation ProjectWith Expert Renovation Insulation</p>
        <p>
        We at CrawlSpace Innovations, LLC don’t just provide insulation that fits everyone. Our insulation services for renovations are customized to the particular energy requirements and style of your house.  
        </p>

        <ul>
          <li>
            By retaining heat in the winter and releasing it in the summer, attic insulation helps to maintain a more constant temperature throughout your living areas.
          </li>
          <li>
          Wall insulation lowers drafts and stabilizes interior temperatures, making it perfect for older homes.
          </li>
          <li>
          Insulation for floors and crawl spaces provides an additional line of protection against cold flooring and moisture accumulation in lower levels.
          </li>
          <li>
          Renovation insulation is ideal for filling up gaps without requiring invasive construction and is made for homes undergoing renovations.
          </li>
        </ul>

        <p>
        Insulation for home additions guarantees that newly added spaces are just as comfortable and functional as the rest of your property.
        </p>
        <p>
          <i>It's time you think of improving your house's condition, especially when there are all the renovations.</i>
        </p>

      </div>
      <div>
        <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/homepage-sub-section.png" alt="">
      </div>
    </div>
</section>

<section class="innovation-sec global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h3 class="large-heading">Why Invest in Renovation Insulation in NJ?</h3>
        <p class="sub-heading">
        Energy leaks and indoor air quality problems are best addressed during a home repair project. So, when you get to know the issue, make sure you address it by hiring the top-rated insulation renovation services in NJ in order to claim these investment returns in the future.
        </p>
      </div>
      <div class="check-box">
        <p class="text-center">Here’s what makes choosing us the smarter move:</p>
        <ul>
          <li>Increases the resale value of your house</li>
          <li>Lowers ongoing utility costs</li>
          <li>Makes the interior environment calmer and cozier</li>
          <li>Helps fulfill energy-saving rebates and codes</li>
        </ul>
      </div>
    </div>
</section>

<section class="right-image-sec global-margin">
    <div class="container-boxed">
      <div>
        <h2 class="large-heading">CrawlSpace Innovations, LLC | The Team You Can Rely On</h2>
        <p>
        Because we value doing things well, we will handle your remodeling with the same level of care that we would our own houses.
        </p>

        <ul>
          <li>
          We never cut corners; every detail, from nooks and crannies to secret areas, is expertly addressed.
          </li>
          <li>
          We educate and do not exploit our clients. With our assistance, you’ll always be aware of your options and be able to make wise selections.
          </li>
          <li>
          We insulate for the future by using materials and techniques that are made to last and require fewer replacements.
          </li>
          <li>
          We actually care and want the best for you. You will experience regular communication, space respect, and a team that genuinely cares about your happiness.
          </li>
        </ul>

        <p><i>
        For fair estimates and to see the difference we make in renovations, give us a call right now.
        </i></p>

      </div>
      <div>
        <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/image-right.webp" alt="">
      </div>
    </div>
</section>

<section class="faq-sec global-margin">
  <div class="container-boxed">
      <div class="text-center">
        <h2 class="large-heading">FAQs</h2>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Can I Blow Insulation Over Existing Insulation?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer active">
          <p class="answer-text">Yes, you can in a lot of situations. As long as it’s dry and compact, blown insulation can be used with mineral or natural fiber insulation as well as settling spray foam.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Is It Possible to Blow Insulation Into Pre-existing Walls?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Yes. It is possible to add blown insulation to existing walls with little disturbance, usually by making a tiny hole in the wall.</p>
        </dd>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Is it possible to cover old insulation with new insulation?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Yes, as long as the original layer is dry and intact, replacing outdated insulation with new can save money and time.</p>
        </dd>
      </div>
  </div>
</section>

<section class="global-margin">
  <div class="container-boxed text-center">
    <h2 class="large-heading">Together, let’s make the most of your renovation</h2>
    <p>By selecting CrawlSpace Innovations, LLC, you’re investing in a smarter, safer, and more efficient house rather than merely improving insulation. We’ll help you through the process with expert advice and top-notch solutions, whether you’re renovating a single room or your entire home.
    </p>
    <p>
      <i>Call us today to schedule a consultation and get your free insulation quote!</i>
    </p>
  </div>
</section>

<div class="ast-container home-page">
  <section class="contact-us bleed-container">
    <div>
      <div class="contact-info">
        <div class="contact-info-content">
          <h2>Start Your Insulation or Crawlspace Project Today</h2>
          <p>Fill out the form and we will respond within 24 hours of your request.</p>
        </div>
        <div class="contact-info-banner">
          <div>
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-banner.png" alt="">
          </div>
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-filler.png" alt="">
        </div>
      </div>
      <div class="contact-form"> <?php echo do_shortcode( '[contact-form-7 id="fc93547" title="Home Contact Form"]' ); ?></div>
    </div>
  </section>

<script>


</script>

<?php
get_footer();
?>