console.log("Custom Script Loaded");

jQuery(function($){
  $('.home-page .tab').on('click', function () {
    $('.home-page .tab').removeClass('active');
    $(this).addClass('active');

    const targetPanel = $(this).data('target');
    $('.home-page .tab-panel').removeClass('active');
    $('.home-page ' + targetPanel).addClass('active');
  });
})// Homepage tab section
  
jQuery(function($){
  const countries = [
    {name: "United States", dial: "+1", code: "us"},
    {name: "Afghanistan (&#x202B;افغانستان&#x202C;&lrm;)", dial: "+93", code: "af"},
    {name: "Albania (Shqipëri)", dial: "+355", code: "al"},
    {name: "Algeria (&#x202B;الجزائر&#x202C;&lrm;)", dial: "+213", code: "dz"},
    {name: "American Samoa", dial: "+1", code: "as"},
    {name: "Andorra", dial: "+376", code: "ad"},
    {name: "Angola", dial: "+244", code: "ao"},
    {name: "Anguilla", dial: "+1", code: "ai"},
    {name: "Antigua and Barbuda", dial: "+1", code: "ag"},
    {name: "Argentina", dial: "+54", code: "ar"},
    {name: "Armenia (Հայաստան)", dial: "+374", code: "am"},
    {name: "Aruba", dial: "+297", code: "aw"},
    {name: "Ascension Island", dial: "+247", code: "ac"},
    {name: "Australia", dial: "+61", code: "au"},
    {name: "Austria (Österreich)", dial: "+43", code: "at"},
    {name: "Azerbaijan (Azərbaycan)", dial: "+994", code: "az"},
    {name: "Bahamas", dial: "+1", code: "bs"},
    {name: "Bahrain (&#x202B;البحرين&#x202C;&lrm;)", dial: "+973", code: "bh"},
    {name: "Bangladesh (বাংলাদেশ)", dial: "+880", code: "bd"},
    {name: "Barbados", dial: "+1", code: "bb"},
    {name: "Belarus (Беларусь)", dial: "+375", code: "by"},
    {name: "Belgium (België)", dial: "+32", code: "be"},
    {name: "Belize", dial: "+501", code: "bz"},
    {name: "Benin (Bénin)", dial: "+229", code: "bj"},
    {name: "Bermuda", dial: "+1", code: "bm"},
    {name: "Bhutan (འབྲུག)", dial: "+975", code: "bt"},
    {name: "Bolivia", dial: "+591", code: "bo"},
    {name: "Bosnia and Herzegovina (Босна и Херцеговина)", dial: "+387", code: "ba"},
    {name: "Botswana", dial: "+267", code: "bw"},
    {name: "Brazil (Brasil)", dial: "+55", code: "br"},
    {name: "British Indian Ocean Territory", dial: "+246", code: "io"},
    {name: "British Virgin Islands", dial: "+1", code: "vg"},
    {name: "Brunei", dial: "+673", code: "bn"},
    {name: "Bulgaria (България)", dial: "+359", code: "bg"},
    {name: "Burkina Faso", dial: "+226", code: "bf"},
    {name: "Burundi (Uburundi)", dial: "+257", code: "bi"},
    {name: "Cambodia (កម្ពុជា)", dial: "+855", code: "kh"},
    {name: "Cameroon (Cameroun)", dial: "+237", code: "cm"},
    {name: "Canada", dial: "+1", code: "ca"},
    {name: "Cape Verde (Kabu Verdi)", dial: "+238", code: "cv"},
    {name: "Caribbean Netherlands", dial: "+599", code: "bq"},
    {name: "Cayman Islands", dial: "+1", code: "ky"},
    {name: "Central African Republic (République centrafricaine)", dial: "+236", code: "cf"},
    {name: "Chad (Tchad)", dial: "+235", code: "td"},
    {name: "Chile", dial: "+56", code: "cl"},
    {name: "China (中国)", dial: "+86", code: "cn"},
    {name: "Christmas Island", dial: "+61", code: "cx"},
    {name: "Cocos (Keeling) Islands", dial: "+61", code: "cc"},
    {name: "Colombia", dial: "+57", code: "co"},
    {name: "Comoros (&#x202B;جزر القمر&#x202C;&lrm;)", dial: "+269", code: "km"},
    {name: "Congo (DRC) (Jamhuri ya Kidemokrasia ya Kongo)", dial: "+243", code: "cd"},
    {name: "Congo (Republic) (Congo-Brazzaville)", dial: "+242", code: "cg"},
    {name: "Cook Islands", dial: "+682", code: "ck"},
    {name: "Costa Rica", dial: "+506", code: "cr"},
    {name: "Côte d’Ivoire", dial: "+225", code: "ci"},
    {name: "Croatia (Hrvatska)", dial: "+385", code: "hr"},
    {name: "Cuba", dial: "+53", code: "cu"},
    {name: "Curaçao", dial: "+599", code: "cw"},
    {name: "Cyprus (Κύπρος)", dial: "+357", code: "cy"},
    {name: "Czech Republic (Česká republika)", dial: "+420", code: "cz"},
    {name: "Denmark (Danmark)", dial: "+45", code: "dk"},
    {name: "Djibouti", dial: "+253", code: "dj"},
    {name: "Dominica", dial: "+1", code: "dm"},
    {name: "Dominican Republic (República Dominicana)", dial: "+1", code: "do"},
    {name: "Ecuador", dial: "+593", code: "ec"},
    {name: "Egypt (&#x202B;مصر&#x202C;&lrm;)", dial: "+20", code: "eg"},
    {name: "El Salvador", dial: "+503", code: "sv"},
    {name: "Equatorial Guinea (Guinea Ecuatorial)", dial: "+240", code: "gq"},
    {name: "Eritrea", dial: "+291", code: "er"},
    {name: "Estonia (Eesti)", dial: "+372", code: "ee"},
    {name: "Eswatini", dial: "+268", code: "sz"},
    {name: "Ethiopia", dial: "+251", code: "et"},
    {name: "Falkland Islands (Islas Malvinas)", dial: "+500", code: "fk"},
    {name: "Faroe Islands (Føroyar)", dial: "+298", code: "fo"},
    {name: "Fiji", dial: "+679", code: "fj"},
    {name: "Finland (Suomi)", dial: "+358", code: "fi"},
    {name: "France", dial: "+33", code: "fr"},
    {name: "French Guiana (Guyane française)", dial: "+594", code: "gf"},
    {name: "French Polynesia (Polynésie française)", dial: "+689", code: "pf"},
    {name: "Gabon", dial: "+241", code: "ga"},
    {name: "Gambia", dial: "+220", code: "gm"},
    {name: "Georgia (საქართველო)", dial: "+995", code: "ge"},
    {name: "Germany (Deutschland)", dial: "+49", code: "de"},
    {name: "Ghana (Gaana)", dial: "+233", code: "gh"},
    {name: "Gibraltar", dial: "+350", code: "gi"},
    {name: "Greece (Ελλάδα)", dial: "+30", code: "gr"},
    {name: "Greenland (Kalaallit Nunaat)", dial: "+299", code: "gl"},
    {name: "Grenada", dial: "+1", code: "gd"},
    {name: "Guadeloupe", dial: "+590", code: "gp"},
    {name: "Guam", dial: "+1", code: "gu"},
    {name: "Guatemala", dial: "+502", code: "gt"},
    {name: "Guernsey", dial: "+44", code: "gg"},
    {name: "Guinea (Guinée)", dial: "+224", code: "gn"},
    {name: "Guinea-Bissau (Guiné Bissau)", dial: "+245", code: "gw"},
    {name: "Guyana", dial: "+592", code: "gy"},
    {name: "Haiti", dial: "+509", code: "ht"},
    {name: "Honduras", dial: "+504", code: "hn"},
    {name: "Hong Kong (香港)", dial: "+852", code: "hk"},
    {name: "Hungary (Magyarország)", dial: "+36", code: "hu"},
    {name: "Iceland (Ísland)", dial: "+354", code: "is"},
    {name: "India (भारत)", dial: "+91", code: "in"},
    {name: "Indonesia", dial: "+62", code: "id"},
    {name: "Iran (&#x202B;ایران&#x202C;&lrm;)", dial: "+98", code: "ir"},
    {name: "Iraq (&#x202B;العراق&#x202C;&lrm;)", dial: "+964", code: "iq"},
    {name: "Ireland", dial: "+353", code: "ie"},
    {name: "Isle of Man", dial: "+44", code: "im"},
    {name: "Israel (&#x202B;ישראל&#x202C;&lrm;)", dial: "+972", code: "il"},
    {name: "Italy (Italia)", dial: "+39", code: "it"},
    {name: "Jamaica", dial: "+1", code: "jm"},
    {name: "Japan (日本)", dial: "+81", code: "jp"},
    {name: "Jersey", dial: "+44", code: "je"},
    {name: "Jordan (&#x202B;الأردن&#x202C;&lrm;)", dial: "+962", code: "jo"},
    {name: "Kazakhstan (Казахстан)", dial: "+7", code: "kz"},
    {name: "Kenya", dial: "+254", code: "ke"},
    {name: "Kiribati", dial: "+686", code: "ki"},
    {name: "Kosovo", dial: "+383", code: "xk"},
    {name: "Kuwait (&#x202B;الكويت&#x202C;&lrm;)", dial: "+965", code: "kw"},
    {name: "Kyrgyzstan (Кыргызстан)", dial: "+996", code: "kg"},
    {name: "Laos (ລາວ)", dial: "+856", code: "la"},
    {name: "Latvia (Latvija)", dial: "+371", code: "lv"},
    {name: "Lebanon (&#x202B;لبنان&#x202C;&lrm;)", dial: "+961", code: "lb"},
    {name: "Lesotho", dial: "+266", code: "ls"},
    {name: "Liberia", dial: "+231", code: "lr"},
    {name: "Libya (&#x202B;ليبيا&#x202C;&lrm;)", dial: "+218", code: "ly"},
    {name: "Liechtenstein", dial: "+423", code: "li"},
    {name: "Lithuania (Lietuva)", dial: "+370", code: "lt"},
    {name: "Luxembourg", dial: "+352", code: "lu"},
    {name: "Macau (澳門)", dial: "+853", code: "mo"},
    {name: "North Macedonia (Македонија)", dial: "+389", code: "mk"},
    {name: "Madagascar (Madagasikara)", dial: "+261", code: "mg"},
    {name: "Malawi", dial: "+265", code: "mw"},
    {name: "Malaysia", dial: "+60", code: "my"},
    {name: "Maldives", dial: "+960", code: "mv"},
    {name: "Mali", dial: "+223", code: "ml"},
    {name: "Malta", dial: "+356", code: "mt"},
    {name: "Marshall Islands", dial: "+692", code: "mh"},
    {name: "Martinique", dial: "+596", code: "mq"},
    {name: "Mauritania (&#x202B;موريتانيا&#x202C;&lrm;)", dial: "+222", code: "mr"},
    {name: "Mauritius (Moris)", dial: "+230", code: "mu"},
    {name: "Mayotte", dial: "+262", code: "yt"},
    {name: "Mexico (México)", dial: "+52", code: "mx"},
    {name: "Micronesia", dial: "+691", code: "fm"},
    {name: "Moldova (Republica Moldova)", dial: "+373", code: "md"},
    {name: "Monaco", dial: "+377", code: "mc"},
    {name: "Mongolia (Монгол)", dial: "+976", code: "mn"},
    {name: "Montenegro (Crna Gora)", dial: "+382", code: "me"},
    {name: "Montserrat", dial: "+1", code: "ms"},
    {name: "Morocco (&#x202B;المغرب&#x202C;&lrm;)", dial: "+212", code: "ma"},
    {name: "Mozambique (Moçambique)", dial: "+258", code: "mz"},
    {name: "Myanmar (Burma) (မြန်မာ)", dial: "+95", code: "mm"},
    {name: "Namibia (Namibië)", dial: "+264", code: "na"},
    {name: "Nauru", dial: "+674", code: "nr"},
    {name: "Nepal (नेपाल)", dial: "+977", code: "np"},
    {name: "Netherlands (Nederland)", dial: "+31", code: "nl"},
    {name: "New Caledonia (Nouvelle-Calédonie)", dial: "+687", code: "nc"},
    {name: "New Zealand", dial: "+64", code: "nz"},
    {name: "Nicaragua", dial: "+505", code: "ni"},
    {name: "Niger (Nijar)", dial: "+227", code: "ne"},
    {name: "Nigeria", dial: "+234", code: "ng"},
    {name: "Niue", dial: "+683", code: "nu"},
    {name: "Norfolk Island", dial: "+672", code: "nf"},
    {name: "North Korea (조선 민주주의 인민 공화국)", dial: "+850", code: "kp"},
    {name: "Northern Mariana Islands", dial: "+1", code: "mp"},
    {name: "Norway (Norge)", dial: "+47", code: "no"},
    {name: "Oman (&#x202B;عُمان&#x202C;&lrm;)", dial: "+968", code: "om"},
    {name: "Pakistan (&#x202B;پاکستان&#x202C;&lrm;)", dial: "+92", code: "pk"},
    {name: "Palau", dial: "+680", code: "pw"},
    {name: "Palestine (&#x202B;فلسطين&#x202C;&lrm;)", dial: "+970", code: "ps"},
    {name: "Panama (Panamá)", dial: "+507", code: "pa"},
    {name: "Papua New Guinea", dial: "+675", code: "pg"},
    {name: "Paraguay", dial: "+595", code: "py"},
    {name: "Peru (Perú)", dial: "+51", code: "pe"},
    {name: "Philippines", dial: "+63", code: "ph"},
    {name: "Poland (Polska)", dial: "+48", code: "pl"},
    {name: "Portugal", dial: "+351", code: "pt"},
    {name: "Puerto Rico", dial: "+1", code: "pr"},
    {name: "Qatar (&#x202B;قطر&#x202C;&lrm;)", dial: "+974", code: "qa"},
    {name: "Réunion (La Réunion)", dial: "+262", code: "re"},
    {name: "Romania (România)", dial: "+40", code: "ro"},
    {name: "Russia (Россия)", dial: "+7", code: "ru"},
    {name: "Rwanda", dial: "+250", code: "rw"},
    {name: "Saint Barthélemy", dial: "+590", code: "bl"},
    {name: "Saint Helena", dial: "+290", code: "sh"},
    {name: "Saint Kitts and Nevis", dial: "+1", code: "kn"},
    {name: "Saint Lucia", dial: "+1", code: "lc"},
    {name: "Saint Martin (Saint-Martin (partie française))", dial: "+590", code: "mf"},
    {name: "Saint Pierre and Miquelon (Saint-Pierre-et-Miquelon)", dial: "+508", code: "pm"},
    {name: "Saint Vincent and the Grenadines", dial: "+1", code: "vc"},
    {name: "Samoa", dial: "+685", code: "ws"},
    {name: "San Marino", dial: "+378", code: "sm"},
    {name: "São Tomé and Príncipe (São Tomé e Príncipe)", dial: "+239", code: "st"},
    {name: "Saudi Arabia (&#x202B;المملكة العربية السعودية&#x202C;&lrm;)", dial: "+966", code: "sa"},
    {name: "Senegal (Sénégal)", dial: "+221", code: "sn"},
    {name: "Serbia (Србија)", dial: "+381", code: "rs"},
    {name: "Seychelles", dial: "+248", code: "sc"},
    {name: "Sierra Leone", dial: "+232", code: "sl"},
    {name: "Singapore", dial: "+65", code: "sg"},
    {name: "Sint Maarten", dial: "+1", code: "sx"},
    {name: "Slovakia (Slovensko)", dial: "+421", code: "sk"},
    {name: "Slovenia (Slovenija)", dial: "+386", code: "si"},
    {name: "Solomon Islands", dial: "+677", code: "sb"},
    {name: "Somalia (Soomaaliya)", dial: "+252", code: "so"},
    {name: "South Africa", dial: "+27", code: "za"},
    {name: "South Korea (대한민국)", dial: "+82", code: "kr"},
    {name: "South Sudan (&#x202B;جنوب السودان&#x202C;&lrm;)", dial: "+211", code: "ss"},
    {name: "Spain (España)", dial: "+34", code: "es"},
    {name: "Sri Lanka (ශ්&zwj;රී ලංකාව)", dial: "+94", code: "lk"},
    {name: "Sudan (&#x202B;السودان&#x202C;&lrm;)", dial: "+249", code: "sd"},
    {name: "Suriname", dial: "+597", code: "sr"},
    {name: "Svalbard and Jan Mayen", dial: "+47", code: "sj"},
    {name: "Sweden (Sverige)", dial: "+46", code: "se"},
    {name: "Switzerland (Schweiz)", dial: "+41", code: "ch"},
    {name: "Syria (&#x202B;سوريا&#x202C;&lrm;)", dial: "+963", code: "sy"},
    {name: "Taiwan (台灣)", dial: "+886", code: "tw"},
    {name: "Tajikistan", dial: "+992", code: "tj"},
    {name: "Tanzania", dial: "+255", code: "tz"},
    {name: "Thailand (ไทย)", dial: "+66", code: "th"},
    {name: "Timor-Leste", dial: "+670", code: "tl"},
    {name: "Togo", dial: "+228", code: "tg"},
    {name: "Tokelau", dial: "+690", code: "tk"},
    {name: "Tonga", dial: "+676", code: "to"},
    {name: "Trinidad and Tobago", dial: "+1", code: "tt"},
    {name: "Tunisia (&#x202B;تونس&#x202C;&lrm;)", dial: "+216", code: "tn"},
    {name: "Turkey (Türkiye)", dial: "+90", code: "tr"},
    {name: "Turkmenistan", dial: "+993", code: "tm"},
    {name: "Turks and Caicos Islands", dial: "+1", code: "tc"},
    {name: "Tuvalu", dial: "+688", code: "tv"},
    {name: "U.S. Virgin Islands", dial: "+1", code: "vi"},
    {name: "Uganda", dial: "+256", code: "ug"},
    {name: "Ukraine (Україна)", dial: "+380", code: "ua"},
    {name: "United Arab Emirates (&#x202B;الإمارات العربية المتحدة&#x202C;&lrm;)", dial: "+971", code: "ae"},
    {name: "United Kingdom", dial: "+44", code: "gb"},
    {name: "United States", dial: "+1", code: "us"},
    {name: "Uruguay", dial: "+598", code: "uy"},
    {name: "Uzbekistan (Oʻzbekiston)", dial: "+998", code: "uz"},
    {name: "Vanuatu", dial: "+678", code: "vu"},
    {name: "Vatican City (Città del Vaticano)", dial: "+39", code: "va"},
    {name: "Venezuela", dial: "+58", code: "ve"},
    {name: "Vietnam (Việt Nam)", dial: "+84", code: "vn"},
    {name: "Wallis and Futuna (Wallis-et-Futuna)", dial: "+681", code: "wf"},
    {name: "Western Sahara (&#x202B;الصحراء الغربية&#x202C;&lrm;)", dial: "+212", code: "eh"},
    {name: "Yemen (&#x202B;اليمن&#x202C;&lrm;)", dial: "+967", code: "ye"},
    {name: "Zambia", dial: "+260", code: "zm"},
    {name: "Zimbabwe", dial: "+263", code: "zw"},
    {name: "Åland Islands", dial: "+358", code: "ax"},
  ];
  
  const selected = document.getElementById("selectedCountry");
  const dropdown = document.getElementById("dropdownList");
  const list = document.getElementById("countryList");
  const searchInput = document.getElementById("countrySearch");
  const hiddenInput = document.getElementById("selectedCountryCode");
  
  // Your settings
  const preferredCountries = ["us"];
  let initialCountry = "auto";
  
  // Handle GeoIP
  function geoIpLookup(callback) {
    fetch('https://ipinfo.io?token=1249ef47ff8b2e')
      .then(resp => resp.json())
      .then(data => callback(data.country.toLowerCase()))
      .catch(error => {
        console.error("GeoIP lookup failed:", error);
        callback("us"); // fallback
      });
  }
  
  // Populate country list with optional filter
  function populateList(filter = "") {
    list.innerHTML = "";
  
    const filtered = countries.filter(c => c.name.toLowerCase().includes(filter.toLowerCase()));
  
    // Preferred first (if no filter)
    if (!filter) {
      preferredCountries.forEach(code => {
        const country = countries.find(c => c.code.toLowerCase() === code.toLowerCase());
        if (country) addOption(country, true);
      });
    }
  
    filtered.forEach(country => {
      // Avoid duplicate preferred countries
      if (!preferredCountries.includes(country.code.toLowerCase()) || filter) {
        addOption(country);
      }
    });
  }
  
  function addOption(country, isPreferred = false) {
    const option = document.createElement("div");
    option.className = "option";
    option.innerHTML = `
      <img src="https://flagpedia.net/data/flags/w580/${country.code}.png" class="flag" />
      <span>${country.name} (${country.dial})</span>
    `;
    option.addEventListener("click", () => {
      setSelectedCountry(country.code);
      dropdown.style.display = "none";
      searchInput.value = "";
      populateList(); // Reset
    });
    list.appendChild(option);
  }
  
  function setSelectedCountry(code) {
    const country = countries.find(c => c.code.toLowerCase() === code.toLowerCase());
    if (country) {
      selected.querySelector(".flag").src = `https://flagpedia.net/data/flags/w580/${country.code}.png`;
      
      hiddenInput.value = country.dial; // ← store the dial code like +91, +1
      
      const arrow = selected.querySelector(".arrow");
      arrow.classList.remove("up");
      arrow.classList.add("down");
    }
  }
  
  // Dropdown toggle
  selected.addEventListener("click", () => {
    const isOpen = dropdown.style.display === "block";
    dropdown.style.display = isOpen ? "none" : "block";
  
    const arrow = selected.querySelector(".arrow");
    arrow.classList.toggle("up", !isOpen);
    arrow.classList.toggle("down", isOpen);
  
    if (!isOpen) searchInput.focus();
  });
  
  // Close dropdown on outside click
  document.addEventListener("click", (e) => {
    if (!dropdown.contains(e.target) && !selected.contains(e.target)) {
      dropdown.style.display = "none";
      selected.querySelector(".arrow").classList.remove("up");
      selected.querySelector(".arrow").classList.add("down");
    }
  });
  
  // Search filter
  searchInput.addEventListener("input", (e) => {
    populateList(e.target.value);
  });
  
  // Initialize
  populateList();
  
  // Handle initial selection
  (function init() {
    const saved = hiddenInput.value;
    if (saved) {
      setSelectedCountry(saved);
    } else if (initialCountry === "auto") {
      geoIpLookup((detectedCountry) => {
        setSelectedCountry(detectedCountry);
      });
    } else {
      setSelectedCountry(initialCountry);
    }
  })();
  
})// Pre Footer Contact Section


jQuery(function($) {
  var $video   = $('#bg-video');
  var $playBtn = $('#play-btn');

  // Play on button click
  $playBtn.on('click', function() {
    if ($video.prop('paused')) {
      // $video.prop('muted', false);
      $video.get(0).play();
      $playBtn.hide();
      $video.siblings('.video-overlay').css({'background': 'rgba(0, 0, 0, 0.4)'})
    }
  });

  // Show button again when video ends
  $video.on('ended', function() {
    $playBtn.show();
    $video.siblings('.video-overlay').css({'background': 'linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url(http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/home-video-background.webp)', 'background-size': 'cover', 'background-position': 'center'})
  });

  // Optional: pause & show button if user clicks on the video itself
  $video.on('click', function() {
    if (!$(this).prop('paused')) {
      $(this).get(0).pause();
      $playBtn.show();
      $video.siblings('.video-overlay').css({'background': 'linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url(http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/home-video-background.webp)',     'background-position': 'center', 'background-position': 'center'})
    }
  });
}); // Homepage Video Section


jQuery(function($){
  var $testimonialSlider = $('.home-testimonial-content');

  $testimonialSlider.slick({
    dots: false,
    infinite: true,
    centerPadding: '10px',
    speed: 800,
    slidesToShow: 1,
    adaptiveHeight: true,
    autoplay: true,
    autoplaySpeed: 8000,
    pauseOnHover: false,
    pauseOnFocus: false,
    arrows: false,
  });

  $('.home-testimonials-control .control-left').on('click', function() {
    $testimonialSlider.slick('slickPrev');
  });

  $('.home-testimonials-control .control-right').on('click', function() {
    $testimonialSlider.slick('slickNext');
  });
}) // Homepage testimonial section


// ______________________________________________________________________________________________________________

// accordian
const headers = document.querySelectorAll(".accordion-header");

  headers.forEach(header => {
    header.addEventListener("click", function () {
      const currentItem = this.parentElement;
      const content = this.nextElementSibling;

      // Close all accordions
      document.querySelectorAll(".accordion-item").forEach(item => {
        item.classList.remove("opened");
        item.querySelector(".accordion-content").style.maxHeight = null;
      });

      // If it was not already opened, open it
      if (!currentItem.classList.contains("opened")) {
        currentItem.classList.add("opened");
        content.style.maxHeight = content.scrollHeight + "px";
      }
    });
  });

jQuery(function($){
  
  // image slider code
  const container = document.querySelector('.container');
    document.querySelector('.slider').addEventListener('input', (e) => {
    container.style.setProperty('--position', `${e.target.value}%`);
  })

  // FAQ
  const disclosures = document.querySelectorAll(".disclosure");

  disclosures.forEach((disclosure) => {
    const question = disclosure.querySelector(".disclosure-question");
    const answer = disclosure.querySelector(".disclosure-answer");

    question.addEventListener("click", () => {
      answer.classList.toggle("active");

      const icon = question.querySelector(".chevron-icon");
      if (answer.classList.contains("active")) {
        icon.style.transform = "rotate(180deg)";
      } else {
        icon.style.transform = "rotate(0deg)";
      }
    });
  });


}) 