<?php
/**
 * Template Name: Services Template
 *
 * Template for displaying the homepage with hero banner.
 */

get_header();
?>

  <div class="overlay"></div>
  <section class="hero-banner bleed-container">
      <div class="hero-content">
        <h1>Smart and Durable <span class="tri-theme-color">Crawl Space Insulation</span> in New Jersey</h1>
        <a href="#" class="btn-quote">GET A QUOTE</a>
      </div>
      <!-- <div class="hero-featured-content">
        <div>
          <p><span>Featured</span></p>
        </div>
        <div>
          <p>Austin, Texas</p>
          <strong>MetLife Corporate Space</strong>
        </div>
      </div> -->
  </section>
</div>


<!-- <div class="ast-container home-page"> -->
<section class="left-image-sec global-margin">
  <div class="container-boxed">      
    <div>
      <img src="<?php echo get_site_url();?>/wp-content/uploads/2025/07/services-sub-section-image.webp" alt="">
    </div>
    <div>
      <h2 class="large-heading">CrawlSpace Innovations, LLC </h2><p class="small-fnt">Leading the Way to the Most Reliable Crawl Space Insulation Services</p>
      <p>If you have a crawl space beneath your home structure, well, this is your call to get it insulated. While you may keep the area as non-worthy for insulation, the fact is that basement crawl space insulation​ is important to regulate the temperature and prevent moisture problems in your home.</p>
      <p>Our team has years of experience in home insulation, which makes us your best pick. At CrawlSpace Innovations, LLC, we offer our clients the best insulation for crawl spaces.</p>
      <p><i>Contact us now to learn about our team, services, and objectives!</i></p>
      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
  </div>
</section>

<!-- </div> -->

<section class="service-details global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h4 class="quote-heading">OUR SERVICES</h4>
        <h3 class="large-heading">Top-Rated Crawl Space Insulation Services You Can Count On</h3>
        <p class="sub-heading">Built for Every Space & Every Stage</p>
      </div>
      <div class="table-config">
        <table style="width:100%;border: none;font-family: 'Poppins', sans-serif;">
          <thead>
            <tr style="background-color: #1456AD; color: white;">
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Aspect</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">What We Offer</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Why it Matters</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Speciality Focus</td>
              <td style="padding: 12px;">High-performance crawl space insulation in NJ</td>
              <td style="padding: 12px;">Enhances comfort, protects structure, and blocks moisture/drafts</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Project Types</td>
              <td style="padding: 12px;">Ideal for new builds, renovations, and first-time insulation</td>
              <td style="padding: 12px;">Flexible solutions tailored to any stage of home improvement</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Materials and Methods</td>
              <td style="padding: 12px;">Energy-efficient materials with precision installation</td>
              <td style="padding: 12px;">Long-lasting performance and lower energy bills</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Expert Team</td>
              <td style="padding: 12px;">Skilled professionals with hands-on experience</td>
              <td style="padding: 12px;">Quality artistry that fits your budget and home needs</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
</section>

<section class="image-slider-sec global-margin">
    <div class="container-boxed">
        <div class="text-center">
          <h3 class="large-heading">Crawl Space Insulation That Makes a Real Difference</h3>
          <p class="sub-heading">Before and After Results You Can See and Feel</p>
        </div>
        <div class="slider-image">
          <main>
            <div class="container">
              <div class="image-container">
                <img
                  class="image-before slider-image"
                src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/home-hero-banner.webp"
                  alt="color photo"
                />
                <img
                  class="image-after slider-image"
                  src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/service-bg.webp"
                  alt="black and white"
                />
              </div>
              <!-- step="10" -->
              <input
                type="range"
                min="0"
                max="100"
                value="50"
                aria-label="Percentage of before photo shown"
                class="slider"
              />
              <div class="slider-line" aria-hidden="true"></div>
              <div class="slider-button" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" viewBox="0 0 256 256">
                  <rect width="256" height="256" fill="none"></rect>
                  <line x1="128" y1="40" x2="128" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <line x1="96" y1="128" x2="16" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></line>
                  <polyline points="48 160 16 128 48 96" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></polyline>
                  <line x1="160" y1="128" x2="240" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <polyline points="208 96 240 128 208 160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></polyline>
                </svg>
              </div>
            </div>
          </main>
        </div>
        <div class="grey-area">
          <p class="text-center">At CrawlSpace Innovations, LLC, we specialize in transforming neglected crawl spaces into clean, efficient, and supportive parts of your home.</p>
          <h5 class="text-center">What Sets Us Apart</h5>
          <div class="why-choose-cards">
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
              <p>Over 20 Years Serving NJ</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-2.png" alt="">
              <p>Family-Owned &amp; Operated</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-3.png" alt="">
              <p>Energy Savings You Can Feel</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-4.png" alt="">
              <p>Fully Licensed &amp; Insured</p>
            </div>
            <div class="why-choose-card">
              <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/06/home-why-choose-5.png" alt="">
              <p>5-Star Rated by Local Homeowners</p>
            </div>
          </div>
        </div>
    </div>
</section>

<section class="new-accordians global-margin">
    <div class="container-boxed">
      <div>
        <h4 class="quote-heading">OUR SERVICES</h4>
        <h3 class="large-heading">Core Services at CrawlSpace Innovations in New Jersey</h3>
        <p class="sub-heading">We specialize in a full range of insulation solutions to improve your home's energy efficiency, air quality, and comfort. Explore our core services below:</p>
      </div>
      <div class="accordion">

        <div class="accordion-item">
          <button class="accordion-header">01 &nbsp;&nbsp; Insulation for Renovations <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>Are you renovating an older house? Now is the ideal moment to improve the interior space. Without sacrificing your aesthetic improvements, our renovation insulation services improve indoor air quality, get rid of drafts, and add contemporary energy efficiency to old rooms. </p>
            <!-- <a class="yello-btn" href="">Get a quote</a> -->
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">02 &nbsp;&nbsp; Home Addition Insulation <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>If you are considering increasing the house's size, then your new area shouldn’t seem like just an add-on. The new addition will be as quiet, pleasant, and energy-efficient as the rest of your house with our basement crawl space insulation.</p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">03 &nbsp;&nbsp; Residential Insulation <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>Every area of your house should feel cozy. Our residential insulation services are customized for your property, from attics and walls to floors and basements.
            </p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">04 &nbsp;&nbsp; Insulation for Attics <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            Your attic may be secretly increasing your energy costs. Our attic insulation service contributes to year-round temperature regulation and air leak prevention.
            </p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">05 &nbsp;&nbsp; Insulation for New Construction <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            Making a new beginning? We use high-density, energy-efficient materials that adhere to modern building regulations when insulating new sections.
            </p>
          </div>
        </div>
        <div class="accordion-item">
          <button class="accordion-header">06 &nbsp;&nbsp; Business/Commercial Insulation <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            Do you need to insulate a commercial or business space? We can handle anything. Our commercial insulation provides long-term efficiency for any sector while adhering to stringent requirements.  
            </p>
          </div>
        </div>  
      </div>
    </div>
</section>

<section class="innovation-sec global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h3 class="large-heading">What sets CrawlSpace Innovations apart in New Jersey?</h3>
        <p class="sub-heading">Expertise, Quality & a Hassle-Free Experience from Start to Finish</p>
      </div>
      <div class="check-box">
        <p class="text-center">Here’s what makes choosing us the smarter move:</p>
        <ul>
          <li>No guesswork, our staff is an expert in insulation</li>
          <li>Your crawl space gets more than a temporary solution</li>
          <li>We begin with a thorough evaluation of your area</li>
          <li>Our team stays involved, communicative, and truly dedicated</li>
          <li>Recommendations are tailored to your home’s layout, state, and goals</li>
          <li>The entire process is designed to be simple and stress-free</li>
          <li>We never compromise on quality; every product is built to last</li>
        </ul>
      </div>
    </div>
</section>

<section class="right-image-sec global-margin">
    <div class="container-boxed">
      <div>
        <h2 class="large-heading">Why Homeowners Across NJ Choose CrawlSpace Innovations?</h2>
        <p>
        We at CrawlSpace Innovations, LLC, provide comfort, trust, and long-lasting results in addition to insulation installation. What makes us different from the others is this:
        </p>

        <h4>Complete Service Assistance, Throughout the Process</h4>
        <p>
        We take care of every detail, from your initial call to the last inspection; there are no shortcuts or surprises.
        </p>

        <h4>Superior Craftsmanship & Materials</h4>
        <p>We only utilize premium materials and tried-and-true methods to guarantee long-term performance and protection.</p>

      </div>
      <div>
        <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/image-right.webp" alt="">
      </div>
    </div>
</section>

<section class="faq-sec global-margin">
  <div class="container-boxed">
      <div class="text-center">
        <h2 class="large-heading">FAQs</h2>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">How Important Is Crawl Space Insulation?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer active">
          <p class="answer-text">In addition to supporting the long-term health of your home, it is crucial for temperature control, moisture prevention, air quality, and pest control.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">What is the ideal thickness for crawl space insulation?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Depending on the material, fiberglass frequently requires a foot, whereas boards or spray foam differ in terms of layers and application.</p>
        </dd>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">When Is It Time to Replace the Insulation in the Crawl Space?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Usually every 20 years, but sooner if your home has been harmed by dampness or vermin, is drafty, or your energy costs increase.</p>
        </dd>
      </div>
  </div>
</section>

<div class="ast-container home-page">
  <section class="contact-us bleed-container">
    <div>
      <div class="contact-info">
        <div class="contact-info-content">
          <h2>Start Your Insulation or Crawlspace Project Today</h2>
          <p>Fill out the form and we will respond within 24 hours of your request.</p>
        </div>
        <div class="contact-info-banner">
          <div>
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-banner.png" alt="">
          </div>
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-filler.png" alt="">
        </div>
      </div>
      <div class="contact-form"> <?php echo do_shortcode( '[contact-form-7 id="fc93547" title="Home Contact Form"]' ); ?></div>
    </div>
  </section>

<script>


</script>

<?php
get_footer();
?>