<?php
/**
 * Template Name: Homepage Template
 *
 * Template for displaying the homepage with hero banner.
 */

get_header();
?>

  <div class="overlay"></div>
    <section class="hero-banner bleed-container">
      <div class="hero-content">
        <div class="small-text">OVER 20 YEARS OF SERVICE IN OCEAN COUNTY.</div>
        <h1>Crawlspace Innovations</h1>
        <p>#1 Insulation Contractor Serving Ocean & Atlantic Counties in New Jersey</p>
        <a href="#" class="btn-quote">GET A QUOTE</a>
      </div>
      <!-- <div class="hero-featured-content">
        <div>
          <p><span>Featured</span></p>
        </div>
        <div>
          <p>Austin, Texas</p>
          <strong>MetLife Corporate Space</strong>
        </div>
      </div> -->
    </section>
  </div>
<div class="ast-container home-page">
  <section class="sub-section">
    <div>
      <h2>Bringing Energy-Smart Insulation to New Jersey Homes & Businesses</h2>
      <p>CrawlSpace Innovations LLC is a trusted, locally owned insulation contractor with over two decades of experience serving Ocean and Atlantic counties in New Jersey.</p>
      <p>Whether you’re building new, remodeling, or just upgrading your home’s energy efficiency, we offer tailored insulation solutions to meet your needs.</p>
      <p>Our licensed professionals use only high-performance, eco-friendly insulation materials, and our work is 100% guaranteed.</p>
      <p>Contact us today to learn more about our insulation services.</p>
      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
    <div>
      <img src="<?php echo get_site_url();?>/wp-content/uploads/2025/06/homepage-sub-section.png" alt="">
    </div>
  </section>
  <section class="home-services">
    <div class="home-services-header">
      <span>Our Services</span>
      <h2>Our Specialized Insulation Services</h2>
      <p>We specialize in a full range of insulation solutions to improve your home's energy efficiency, air quality, and comfort. Explore our core services below:</p>
    </div>
    <div class="home-services-content">
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-crawl-sapce-innovation.png" alt="">
        <div>
          <h3>Crawl space insulation</h3>
          <p>Sealing and insulating your crawl space is one of the most effective ways to protect your home. It prevents moisture from seeping in, which helps stop mold growth and structural damage.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-attic-insulation.png" alt="">
        <div>
          <h3>Attic insulation</h3>
          <p>Upgrade your attic insulation to reduce utility bills and maintain indoor temperature year-round.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-new-construction-insulation.png" alt="">
        <div>
          <h3>New construction insulation</h3>
          <p>Insulation solutions tailored for new homes to meet building codes and maximize energy efficiency.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-renovation-insulation.png" alt="">
        <div>
          <h3>Renovation insulation</h3>
          <p>Bringing older homes up to modern insulation standards during your remodeling process.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-addition-Insulation.png" alt="">
        <div>
          <h3>Addition Insulation</h3>
          <p>Ensure comfort and continuity when adding to your home with specialized insulation for additions.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-commercial-Insulation.png" alt="">
        <div>
          <h3>Commercial Insulation</h3>
          <p>Professional-grade insulation for office buildings, retail spaces, and industrial sites.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
      <div class="services-card">
        <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-service-residential-insulation.png" alt="">
        <div>
          <h3>Residential insulation</h3>
          <p>Custom insulation services for single-family homes, townhouses, and multi-family dwellings.</p>
        </div>
        <a href="">Learn More<span>→</span></a>
      </div>
    </div>
  </section>

  <section class="info-banner">
    <div class="video-container">
      <video id="bg-video" class="bg-video" muted playsinline preload="metadata" src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-video-section.mp4"></video>
      <div class="video-overlay"></div>
    </div>
    
    <div class="content">
      <h2>We provide services to your crawlspace all the way up to your attic.</h2>
      <p class="info-sub-head cl-border">Myke Patrick Hogan, CEO</p>
    </div>
    
    <button id="play-btn" class="play-btn">
      <svg width="25" height="28" viewBox="0 0 25 28" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M23.7143 14L1.09521 0.904785V27.0953L23.7143 14Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>
    </button>
    <!-- <button id="volume-btn"></button> -->
  </section>

  <section class="tab-section">
    <div class="tab-panels">
      <div class="tab-panel active" id="panel-renovation">
        <div class="overlay">
          <p class="subheading">Explore our work</p>
          <h1 class="heading">See what we can do together.</h1>
          <button class="cta-btn">Contact Us Now</button>
        </div>
      </div>

      <div class="tab-panel" id="panel-addition">
        <div class="overlay">
          <p class="subheading">Add value with insulation</p>
          <h1 class="heading">Make your addition energy-efficient.</h1>
          <button class="cta-btn">Contact Us Now</button>
        </div>
      </div>

      <div class="tab-panel" id="panel-commercial">
        <div class="overlay">
          <p class="subheading">Commercial insulation expertise</p>
          <h1 class="heading">Insulate your business smartly.</h1>
          <button class="cta-btn">Contact Us Now</button>
        </div>
      </div>
    </div>

    <div class="tabs">
      <div class="tab active" data-target="#panel-renovation">Renovation insulation</div>
      <div class="tab" data-target="#panel-addition">Addition insulation</div>
      <div class="tab" data-target="#panel-commercial">Commercial Insulation</div>
    </div>
  </section>
  <section class="why-choose">
    <div>
      <p class="why-choose-sub-head">Built on Experience, Driven by Quality</p>
      <h2>Why Choose Crawlspace Innovations</h2>
      <div class="why-choose-cards">
        <div class="why-choose-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/06/home-why-choose-1.png" alt="">
          <p>Over 20 Years Serving NJ</p>
        </div>
        <div class="why-choose-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/06/home-why-choose-2.png" alt="">
          <p>Family-Owned & Operated</p>
        </div>
        <div class="why-choose-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/06/home-why-choose-3.png" alt="">
          <p>Energy Savings You Can Feel</p>
        </div>
        <div class="why-choose-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/06/home-why-choose-4.png" alt="">
          <p>Fully Licensed & Insured</p>
        </div>
        <div class="why-choose-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/06/home-why-choose-5.png" alt="">
          <p>5-Star Rated by Local Homeowners</p>
        </div>
      </div>
    </div>
  </section>
  <section class="work-action">
    <div>
      <p>Our Work in Action</p>
      <h2>We do it best.</h2>
      <div class="work-action-cards">
        <div class="work-action-card">
          <div class="work-action-card-content">
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-work-action-Allstate-Employee-Lounge.jpg" alt="" class="work-action-bg-img">
            <p class="work-action-location">Miami, Florida</p>
            <h3 class="work-action-title">Allstate Employee Lounge</h3>
            <p class="work-ction-date">1.22.22</p>
          </div>
        </div>
        <div class="work-action-card">
          <div class="work-action-card-content">
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-work-Unity-Team-Hub.jpg" alt="" class="work-action-bg-img">
            <p class="work-action-location">New York, New York</p>
            <h3 class="work-action-title">Unity Team Hub</h3>
            <p class="work-ction-date">1.2.22</p>
          </div>
        </div>
        <div class="work-action-card">
          <div class="work-action-card-content">
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-work-Summit-Crew-Corner.jpg" alt="" class="work-action-bg-img">
            <p class="work-action-location">Miami, Florida</p>
            <h3 class="work-action-title">Summit Crew Corner</h3>
            <p class="work-ction-date">11.20.21</p>
          </div>
        </div>
        <div class="work-action-card">
          <div class="work-action-card-content">
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-work-Horizon-Break-Zone.jpg" alt="" class="work-action-bg-img">
            <p class="work-action-location">Los Angeles, California</p>
            <h3 class="work-action-title">Horizon Break Zone</h3>
            <p class="work-ction-date">6.8.21</p>
          </div>
        </div>
        <div class="work-action-card">
          <div class="work-action-card-content">
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-work-Vertex-Wellness-Lounge.jpg" alt="" class="work-action-bg-img">
            <p class="work-action-location">San Francisco, California</p>
            <h3 class="work-action-title">Vertex Wellness Lounge</h3>
            <p class="work-ction-date">Vertex Wellness Lounge</p>
          </div>
        </div>
        <div class="work-action-card">
          <div class="work-action-card-content">
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-work-Nexus-Staff-Retreat.jpg" alt="" class="work-action-bg-img">
            <p class="work-action-location">San Francisco, California</p>
            <h3 class="work-action-title">San Francisco, California</h3>
            <p class="work-ction-date">10.29.20</p>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div class="ast-container home-page">
  <section class="benefit-insulation bleed-container">
    <div>
      <p>Why Insulation Matters</p>
      <h2>Benefits of Insulation</h2>
      <div class="benefit-insulation-cards">
        <div class="benefit-insulation-card">
          <div class="benefit-insulation-content">
            <div class="benefit-insulation-img">
              <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-insulation-1.png" alt="" class="">
            </div>
            <h3 class="benefit-insulation-title">Save money on your energy bills</h3>
            <p class="benefit-insulation-info">Insulation keeps your home cooler in summer and warmer in winter, reducing energy bills.</p>
          </div>
        </div>
        <div class="benefit-insulation-card">
          <div class="benefit-insulation-content">
            <div class="benefit-insulation-img">
              <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-insulation-2.png" alt="" class="">
            </div>
            <h3 class="benefit-insulation-title">Improve the comfort of your home</h3>
            <p class="benefit-insulation-info">Insulation can help to reduce drafts and noise, which can make your home more comfortable to live in.</p>
          </div>
        </div>
        <div class="benefit-insulation-card">
          <div class="benefit-insulation-content">
            <div class="benefit-insulation-img">
              <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-insulation-3.png" alt="" class="">
            </div>
            <h3 class="benefit-insulation-title">Protect your home from moisture damage</h3>
            <p class="benefit-insulation-info">Insulation helps to keep moisture out of your crawl space, which can help to prevent mold and rot.</p>
          </div>
        </div>
        <div class="benefit-insulation-card">
          <div class="benefit-insulation-content">
            <div class="benefit-insulation-img">
              <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-insulation-4.png" alt="" class="">
            </div>
            <h3 class="benefit-insulation-title">Increase the value of your home</h3>
            <p class="benefit-insulation-info">Insulation is an attractive feature for homebuyers, and can add value to your home when you sell it.</p>
          </div>
        </div>
        <div class="benefit-insulation-card">
          <div class="benefit-insulation-content">
            <div class="benefit-insulation-img">
              <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-insulation-5.png" alt="" class="">
            </div>
            <h3 class="benefit-insulation-title">Enhance indoor air quality</h3>
            <p class="benefit-insulation-info">Insulation blocks allergens and pollutants, keeping indoor air cleaner.</p>
          </div>
        </div>
        <div class="benefit-insulation-card">
          <div class="benefit-insulation-content">
            <div class="benefit-insulation-img">
              <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-insulation-6.png" alt="" class="">
            </div>
            <h3 class="benefit-insulation-title">Protect HVAC systems</h3>
            <p class="benefit-insulation-info">It reduces strain on heating and cooling units, helping them last longer.</p>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div class="ast-container home-page">
  <section class="our-approach">
    <div>
      <p>What Sets Us Apart</p>
      <h2>Our Approach to Crawlspace & Insulation Services</h2>
      <div class="our-approach-cards">
        <div class="our-approach-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/our-approach-1.jpg" alt="" class="div our-approach-img">
          <div class="our-approach-content">
            <h3 class="our-approach-title">Fixing Contractor Mistakes with Expert Help</h3>
            <p class="our-approach-info">Are you dealing with an insulation or crawlspace mess caused by a contractor? If so, our team of experts at Crawlspace Innovations LLC. can help. We have the expertise and experience to assess the situation and provide the best solution for your needs.</p>
          </div>
        </div>
        <div class="our-approach-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/our-approach-2.jpg" alt="" class="div our-approach-img">
          <div class="our-approach-content">
            <h3 class="our-approach-title">Reliable Solutions for Crawlspace and Insulation</h3>
            <p class="our-approach-info">Our crawlspace and insulation team are committed to providing quality service and ensuring that your home is free from any potential risks. With our solutions, you can rest easy knowing that your insulation and crawlspace are in the best condition possible.</p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="home-testimonials">
    <div>
      <div class="home-testimonials-banner"><img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-testimonials-banner.png" alt=""></div>
      <div class="home-testimonials-header">
        <p>Client Reviews</p>
        <h2>What Our Clients Say</h2>
        <div class="home-testimonials-control">
          <buttons class=" control-left">
            <svg width="36" height="16" viewBox="0 0 36 16" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path fill-rule="evenodd" clip-rule="evenodd" d="M36 7.61539C36 8.21622 35.4963 8.7033 34.875 8.7033L10.358 8.7033L3.84099 8.7033L8.6705 13.3736C9.10984 13.7984 9.10984 14.4873 8.6705 14.9121C8.23116 15.337 7.51884 15.337 7.0795 14.9121L0.329498 8.38466C-0.10984 7.9598 -0.10984 7.27097 0.329498 6.84611L7.0795 0.318642C7.51884 -0.106214 8.23116 -0.106214 8.6705 0.318642C9.10984 0.743498 9.10984 1.43233 8.6705 1.85718L3.84099 6.52747L34.875 6.52748C35.4963 6.52748 36 7.01455 36 7.61539Z" fill="#070707"/>
            </svg>
          </buttons>
          <buttons class=" control-right">
            <svg width="86" height="16" viewBox="0 0 86 16" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path fill-rule="evenodd" clip-rule="evenodd" d="M9.08126e-08 7.61539C9.79775e-08 8.21622 0.50368 8.7033 1.125 8.7033L75.642 8.7033L82.159 8.7033L77.3295 13.3736C76.8902 13.7984 76.8902 14.4873 77.3295 14.9121C77.7688 15.337 78.4812 15.337 78.9205 14.9121L85.6705 8.38465C86.1098 7.9598 86.1098 7.27097 85.6705 6.84611L78.9205 0.318641C78.4812 -0.106215 77.7688 -0.106215 77.3295 0.318641C76.8902 0.743497 76.8902 1.43233 77.3295 1.85718L82.159 6.52747L1.125 6.52748C0.50368 6.52748 8.36477e-08 7.01455 9.08126e-08 7.61539Z" fill="#070707"/>
            </svg>
          </buttons>
        </div>
      </div>
      <div class="home-testimonial-content">
        <?php
          $query = new WP_Query(array(
            'post_type' => 'testimonials',
            'post_status' => 'publish',
            'posts_per_page' => 5,
          ));

          if ($query->have_posts()) {
            while ($query->have_posts()) {
              $query->the_post();
              echo '<div class="home-testimonial-card">';
                echo '<h2><a href="' . get_permalink() . '">' . get_the_title() . '</a></h2>';
                echo '<div class="testimonial-content">';
                  echo '<p>' . trim(strip_tags(get_the_content())) . '</p>';
                echo '</div>';
                echo '<p class="testimonial-location">'.get_field('location').'<p>';
              echo '</div>';
            }
            wp_reset_postdata();
          }
        ?>
      </div>
    </div>
  </section>
  <section class="recent-posts">
    <div>
      <p>Recent Posts</p>
      <h2>What's new?</h2>
      <div class="recent-posts-content">
        
        <?php
        $query = new WP_Query(array(
          'post_type' => 'post',
          'post_status' => 'publish',
          'posts_per_page' => 3,
        ));

        if ($query->have_posts()) {
          while ($query->have_posts()) {
            echo '<div class="recent-post-card">';
              $query->the_post();
              if(has_post_thumbnail(get_the_ID())){
                echo '<div class="recent-post-img">';
                echo the_post_thumbnail(get_the_ID(), 'thumbnail');
                echo '</div>';
              }
              echo '<div class="recent-post-content">';
                echo '<h2><a href="' . get_permalink() . '">' . get_the_title() . '</a></h2>';
                echo '<p>' . get_the_excerpt() . '</p>';
                echo '<p>' . get_field('location') . '</p>';
              echo '</div>';
            echo '</div>';
          }
          wp_reset_postdata();
        }
        ?>
      </div>
    </div>
  </section>
</div>
<div class="ast-container home-page">
  <section class="contact-us bleed-container">
    <div>
      <div class="contact-info">
        <div class="contact-info-content">
          <h2>Start Your Insulation or Crawlspace Project Today</h2>
          <p>Fill out the form and we will respond within 24 hours of your request.</p>
        </div>
        <div class="contact-info-banner">
          <div>
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-banner.png" alt="">
          </div>
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-filler.png" alt="">
        </div>
      </div>
      <div class="contact-form"> <?php echo do_shortcode( '[contact-form-7 id="fc93547" title="Home Contact Form"]' ); ?></div>
    </div>
  </section>

<?php
get_footer();
?>