<?php
/**
 * Template Name: Addition Insulation 
 *
 * Template for displaying the homepage with hero banner.
 */

get_header();
?>

  <div class="overlay"></div>
  <section class="hero-banner bleed-container">
      <div class="hero-content">
        <h1>Addition Insulation Services by <span class="tri-theme-color">CrawlSpace Innovations, LLC</span></h1>
         <p>Where Comfort Meets Expansion</p>
        <a href="#" class="btn-quote">GET A QUOTE</a>
      </div>
      <!-- <div class="hero-featured-content">
        <div>
          <p><span>Featured</span></p>
        </div>
        <div>
          <p>Austin, Texas</p>
          <strong>MetLife Corporate Space</strong>
        </div>
      </div> -->
  </section>
</div>


<!-- <div class="ast-container home-page"> -->
<section class="left-image-sec global-margin">
  <div class="container-boxed">      
    <div>
      <img src="<?php echo get_site_url();?>/wp-content/uploads/2025/07/services-sub-section-image.webp" alt="">
    </div>
    <div>
      <h2 class="large-heading">Best Addition Insulation </h2><p class="small-fnt">Services in Tuckerton, NJ</p>
      <p><i>Why it Matters</i></p>
      <p>It usually happens that people treat insulation for new additions as an afterthought, leading to drafty rooms, uneven temperatures, and skyrocketing energy bills. But not anymore! </p>
      <p>Our addition insulation service can close those gaps. We do this by:</p>

      <ul>
        <li>
        Putting a seal on air leaks to prevent energy waste
        </li>
        <li>
        Regulating indoor temperature across old and new sections
        </li>
        <li>
        Protecting HVAC systems from overwork
        </li>
        <li>
        Controlling moisture intrusion and mold growth
        </li>
      </ul>

      <!-- <p><i>Contact us now to learn about our team, services, and objectives!</i></p> -->
      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
  </div>
</section>

<!-- </div> -->

<section class="service-details global-margin">
    <div class="container-boxed">
      <div class="text-center">
        <h4 class="quote-heading">Expand Your Home, Not Your Energy Bills</h4>
        <h3 class="large-heading">Areas We Insulate During Additions:</h3>
        <p class="sub-heading">We provide expert insulation solutions for home additions across the country</p>
      </div>
      <div class="table-config">
        <table style="width:100%;border: none;font-family: 'Poppins', sans-serif;">
          <thead>
            <tr style="background-color: #1456AD; color: white;">
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Area</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Common Issues</th>
              <th style="padding: 15px 25px;text-align: left;font-size: 20px;border: none;">Our Solutions</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Walls</td>
              <td style="padding: 12px;">Heat escape, drafts</td>
              <td style="padding: 12px;">Dense Pack Cellulose or Fiberglass Batts</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Ceilings</td>
              <td style="padding: 12px;">Temperature imbalance</td>
              <td style="padding: 12px;">Spray Foam or Blow-In Insulation</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Floors over garages or crawlspaces</td>
              <td style="padding: 12px;">Cold floors, moisture</td>
              <td style="padding: 12px;">Rigid Foam Boards + Vapor Barriers</td>
            </tr>
            <tr>
              <td style="padding: 12px; font-weight: bold;">Rooflines (especially with cathedral ceilings)</td>
              <td style="padding: 12px;">Heat loss</td>
              <td style="padding: 12px;">High-R Rigid Foam or Closed Cell Spray Foam</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
</section>

<section class="image-slider-sec global-margin content-section-box">
    <div class="container-boxed">
        <div class="text-center">
          <h3 class="large-heading">Our Proven Process for Addition Insulation</h3>
          <p class="sub-heading">Before and After Results You Can See and Feel</p>
        </div>
        <div class="slider-image">
          <main>
            <div class="container">
              <div class="image-container">
                <img
                  class="image-before slider-image"
                src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/home-hero-banner.webp"
                  alt="color photo"
                />
                <img
                  class="image-after slider-image"
                  src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/service-bg.webp"
                  alt="black and white"
                />
              </div>
              <!-- step="10" -->
              <input
                type="range"
                min="0"
                max="100"
                value="50"
                aria-label="Percentage of before photo shown"
                class="slider"
              />
              <div class="slider-line" aria-hidden="true"></div>
              <div class="slider-button" aria-hidden="true">
                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" viewBox="0 0 256 256">
                  <rect width="256" height="256" fill="none"></rect>
                  <line x1="128" y1="40" x2="128" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <line x1="96" y1="128" x2="16" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></line>
                  <polyline points="48 160 16 128 48 96" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="16"
                  ></polyline>
                  <line x1="160" y1="128" x2="240" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"
                  ></line>
                  <polyline points="208 96 240 128 208 160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></polyline>
                </svg>
              </div>
            </div>
          </main>
        </div>
        <div class="grey-area">
          <!-- <p class="text-center">At CrawlSpace Innovations, LLC, we specialize in transforming neglected crawl spaces into clean, efficient, and supportive parts of your home.</p> -->
          <!-- <h5 class="text-center">What Sets Us Apart</h5> -->
          <div class="why-choose-cards">
            <div class="why-choose-card">
              <h4>On-Site Evaluation & Energy Assessment</h4>
              <p>We start with a thorough inspection of your home and new addition plans to identify insulation needs, gaps, and best-fit materials.</p>
            </div>
            <div class="why-choose-card">
              <h4>Customized Insulation Plan</h4>
              <p>Every home is different. Based on your project scope, budget, and climate zone, we customize a plan for maximum comfort and efficiency.</p>
            </div>
            <div class="why-choose-card">
              <h4>Expert Installation</h4>
              <p>Our certified team uses premium-grade, code-compliant materials and follows best industry practices to ensure a durable insulation system.</p>
            </div>
            <div class="why-choose-card">
              <h4>Final Walkthrough & Support</h4>
              <p>Once installation is complete, we show you the work and share maintenance tips to ensure performance longevity.</p>
            </div>
          </div>
        </div>
    </div>
</section>

<section class="new-accordians global-margin">
    <div class="container-boxed">
      <div>
        <!-- <h4 class="quote-heading">OUR SERVICES</h4> -->
        <h3 class="large-heading">Why Choose CrawlSpace Innovations, LLC for Addition Insulation in New Jersey?</h3>
        <!-- <p class="sub-heading">We specialize in a full range of insulation solutions to improve your home's energy efficiency, air quality, and comfort. Explore our core services below:</p> -->
      </div>
      <div class="accordion">

        <div class="accordion-item">
          <button class="accordion-header">01 &nbsp;&nbsp; Deep Local Experience  <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>We understand NJ homes, weather conditions, and follow local rules and regulations.</p>
            <!-- <a class="yello-btn" href="">Get a quote</a> -->
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">02 &nbsp;&nbsp; Premium Materials <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>From spray foam to batt insulation, we use only top-rated, durable products.</p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">03 &nbsp;&nbsp; Tailored Approach  <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            No stereotypical work; we align our service with your goals and home layout.
            </p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">04 &nbsp;&nbsp; Clear Communication  <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            Transparent pricing, on-time work, and no hidden costs.
            </p>
          </div>
        </div>

        <div class="accordion-item">
          <button class="accordion-header">05 &nbsp;&nbsp; Post-Install Support  <span class="right-arrow">&#10142;</span></button>
          <div class="accordion-content">
            <p>
            We’re here even after the job is done.
            </p>
          </div>
        </div> 
      </div>
    </div>
</section>

<section class="right-image-sec global-margin">
    <div class="container-boxed">
      <div>
        <h2 class="large-heading">Ready to Warm Up Your New Space?</h2>
        <p>
        Your new room, sunroom, garage conversion, or bonus space deserves the same protection and comfort as the rest of your home. Let CrawlSpace Innovations, LLC help you insulate smarter with our Addition insulation services across New Jersey.
        </p>

        <h4>Call us today for a free consultation and quote!</h4>

      </div>
      <div>
        <img src="http://192.168.75.205/Staging/csi/wp-content/uploads/2025/07/image-right.webp" alt="">
      </div>
    </div>
</section>

<section class="faq-sec global-margin">
  <div class="container-boxed">
      <div class="text-center">
        <h2 class="large-heading">FAQs</h2>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">What insulation materials are best for additions?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer active">
          <p class="answer-text">There are no specific materials, as it depends on the structure. We commonly use fiberglass batts, spray foam, rigid foam board, and cellulose, depending on your design and efficiency goals.</p>
        </dd>
      </div>

      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">Will my HVAC system need to change after insulating the new addition?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Proper insulation helps reduce the load on your existing HVAC system. We can analyze whether it needs an upgrade or not.</p>
        </dd>
      </div>
      <div class="disclosure">
        <dt>
          <button type="button" class="disclosure-question">
            <span class="question-text">How much does addition insulation cost?</span>
            <span>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="chevron-icon">
                <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
              </svg>
            </span>
          </button>
        </dt>
        <dd class="disclosure-answer">
          <p class="answer-text">Costs vary based on square footage, material, and structure. At Crawlspace Innovations, LLC, we provide transparent estimates after your site inspection.</p>
        </dd>
      </div>
  </div>
</section>

<div class="ast-container home-page">
  <section class="contact-us bleed-container">
    <div>
      <div class="contact-info">
        <div class="contact-info-content">
          <h2>Start Your Insulation or Crawlspace Project Today</h2>
          <p>Fill out the form and we will respond within 24 hours of your request.</p>
        </div>
        <div class="contact-info-banner">
          <div>
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-banner.png" alt="">
          </div>
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-filler.png" alt="">
        </div>
      </div>
      <div class="contact-form"> <?php echo do_shortcode( '[contact-form-7 id="fc93547" title="Home Contact Form"]' ); ?></div>
    </div>
  </section>

<script>


</script>

<?php
get_footer();
?>