<?php
/**
 * Template Name: About page
 *
 * Template for displaying the homepage with hero banner.
 */

get_header();
?>

  <div class="overlay"></div>
    <section class="hero-banner bleed-container">
      <div class="hero-content">
        <div class="small-text">OVER 20 YEARS OF SERVICE IN OCEAN COUNTY.</div>
        <h1>About Us</h1>
        <p>#1 Insulation Contractor Serving Ocean & Atlantic Counties in New Jersey</p>
        <!-- <a href="#" class="btn-quote">GET A QUOTE</a> -->
      </div>
      <!-- <div class="hero-featured-content">
        <div>
          <p><span>Featured</span></p>
        </div>
        <div>
          <p>Austin, Texas</p>
          <strong>MetLife Corporate Space</strong>
        </div>
      </div> -->
    </section>
  </div>
<div class="ast-container home-page">
  <section class="sub-section">
    <div>
      <h2>Bringing Energy-Smart Insulation to New Jersey Homes & Businesses</h2>
      <p>CrawlSpace Innovations LLC is a trusted, locally owned insulation contractor with over two decades of experience serving Ocean and Atlantic counties in New Jersey.</p>
      <p>Whether you’re building new, remodeling, or just upgrading your home’s energy efficiency, we offer tailored insulation solutions to meet your needs.</p>
      <p>Our licensed professionals use only high-performance, eco-friendly insulation materials, and our work is 100% guaranteed.</p>
      <p>Contact us today to learn more about our insulation services.</p>
      <a href="#" class="csi-btn-sec round-btn">Schedule Your Free Estimate</a>
    </div>
    <div>
      <img src="<?php echo get_site_url();?>/wp-content/uploads/2025/06/homepage-sub-section.png" alt="">
    </div>
  </section>

  <section class="info-banner">
    <div class="video-container">
      <video id="bg-video" class="bg-video" muted playsinline preload="metadata" src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-video-section.mp4"></video>
      <div class="video-overlay"></div>
    </div>
    
    <div class="content">
      <h2>We provide services to your crawlspace all the way up to your attic.</h2>
      <p class="info-sub-head cl-border">Myke Patrick Hogan, CEO</p>
    </div>
    
    <button id="play-btn" class="play-btn">
      <svg width="25" height="28" viewBox="0 0 25 28" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M23.7143 14L1.09521 0.904785V27.0953L23.7143 14Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>
    </button>
    <!-- <button id="volume-btn"></button> -->
  </section>
</div>

<div class="ast-container home-page">
  <section class="our-approach">
    <div>
      <p>What Sets Us Apart</p>
      <h2>Our Approach to Crawlspace & Insulation Services</h2>
      <div class="our-approach-cards">
        <div class="our-approach-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/our-approach-1.jpg" alt="" class="div our-approach-img">
          <div class="our-approach-content">
            <h3 class="our-approach-title">Fixing Contractor Mistakes with Expert Help</h3>
            <p class="our-approach-info">Are you dealing with an insulation or crawlspace mess caused by a contractor? If so, our team of experts at Crawlspace Innovations LLC. can help. We have the expertise and experience to assess the situation and provide the best solution for your needs.</p>
          </div>
        </div>
        <div class="our-approach-card">
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/our-approach-2.jpg" alt="" class="div our-approach-img">
          <div class="our-approach-content">
            <h3 class="our-approach-title">Reliable Solutions for Crawlspace and Insulation</h3>
            <p class="our-approach-info">Our crawlspace and insulation team are committed to providing quality service and ensuring that your home is free from any potential risks. With our solutions, you can rest easy knowing that your insulation and crawlspace are in the best condition possible.</p>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<div class="ast-container home-page">
  <section class="contact-us bleed-container">
    <div>
      <div class="contact-info">
        <div class="contact-info-content">
          <h2>Start Your Insulation or Crawlspace Project Today</h2>
          <p>Fill out the form and we will respond within 24 hours of your request.</p>
        </div>
        <div class="contact-info-banner">
          <div>
            <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-banner.png" alt="">
          </div>
          <img src="<?= get_site_url() ?>/wp-content/uploads/2025/07/home-contact-filler.png" alt="">
        </div>
      </div>
      <div class="contact-form"> <?php echo do_shortcode( '[contact-form-7 id="fc93547" title="Home Contact Form"]' ); ?></div>
    </div>
  </section>

<?php
get_footer();
?>