<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

	// Enqueue slick and custom css
	wp_enqueue_style( 'custom-style',  get_stylesheet_directory_uri() . '/css/custom.css', [], time(), 'all' );
	wp_enqueue_style( 'global-style',  get_stylesheet_directory_uri() . '/css/global.css', [], time(), 'all' );
	wp_enqueue_style( 'responsive-style',  get_stylesheet_directory_uri() . '/css/responsive.css', [], time(), 'all' );
	wp_enqueue_style( 'slick-style',  get_stylesheet_directory_uri() . '/css/slick.min.css', [], time(), 'all' );

	// Enqueue jQuery, slick and custom script
	wp_enqueue_script( 'jquery-script', get_stylesheet_directory_uri() . '/js/jquery.min.js', [], time(), false);
	wp_enqueue_script( 'slick-script', get_stylesheet_directory_uri() . '/js/slick.min.js', [], time(), false);
	wp_enqueue_script( 'custom-script', get_stylesheet_directory_uri() . '/js/custom.js', [], time(), true);

	// Enqueue intl input assets
	// wp_enqueue_script('intl-tel-input-js', 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js', array('jquery'), null, true);
	// wp_enqueue_style('intl-tel-input-css', 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css', array(), null);
}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

/**
 * Register Custom Post Type: Testimonials
 */
function register_testimonials_cpt() {

	$labels = array(
		'name'                  => _x( 'Testimonials', 'Post Type General Name', 'astra-child' ),
		'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'astra-child' ),
		'menu_name'             => __( 'Testimonials', 'astra-child' ),
		'name_admin_bar'        => __( 'Testimonial', 'astra-child' ),
		'archives'              => __( 'Testimonial Archives', 'astra-child' ),
		'attributes'            => __( 'Testimonial Attributes', 'astra-child' ),
		'parent_item_colon'     => __( 'Parent Testimonial:', 'astra-child' ),
		'all_items'             => __( 'All Testimonials', 'astra-child' ),
		'add_new_item'          => __( 'Add New Testimonial', 'astra-child' ),
		'add_new'               => __( 'Add New', 'astra-child' ),
		'new_item'              => __( 'New Testimonial', 'astra-child' ),
		'edit_item'             => __( 'Edit Testimonial', 'astra-child' ),
		'update_item'           => __( 'Update Testimonial', 'astra-child' ),
		'view_item'             => __( 'View Testimonial', 'astra-child' ),
		'view_items'            => __( 'View Testimonials', 'astra-child' ),
		'search_items'          => __( 'Search Testimonial', 'astra-child' ),
		'not_found'             => __( 'Not found', 'astra-child' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'astra-child' ),
		'featured_image'        => __( 'Featured Image', 'astra-child' ),
		'set_featured_image'    => __( 'Set featured image', 'astra-child' ),
		'remove_featured_image' => __( 'Remove featured image', 'astra-child' ),
		'use_featured_image'    => __( 'Use as featured image', 'astra-child' ),
		'insert_into_item'      => __( 'Insert into testimonial', 'astra-child' ),
		'uploaded_to_this_item' => __( 'Uploaded to this testimonial', 'astra-child' ),
		'items_list'            => __( 'Testimonials list', 'astra-child' ),
		'items_list_navigation' => __( 'Testimonials list navigation', 'astra-child' ),
		'filter_items_list'     => __( 'Filter testimonials list', 'astra-child' ),
	);
	$args = array(
		'label'                 => __( 'Testimonial', 'astra-child' ),
		'description'           => __( 'Post Type for Testimonials', 'astra-child' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'revisions' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-testimonial',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'testimonials', $args );

}
add_action( 'init', 'register_testimonials_cpt', 0 );
