<?php
// Enqueue Parent theme Style
function hello_elementor_child_enqueue_styles() {
    wp_enqueue_style( 'hello-elementor-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'hello-elementor-style-1', get_stylesheet_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles' );

function get_packages_api_content() {
    $response = wp_remote_get("http://localhost:8080/api/v1/stripe/packages-with-products");

    if (is_wp_error($response)) {
        return "API Request Error: " . $response->get_error_message();
    }

    $body = json_decode(wp_remote_retrieve_body($response), true);

    if (!$body || !isset($body["data"])) {
        return "Invalid API Response";
    }

    $html = '<div class="packages-wrapper">';

    foreach ($body["data"] as $pkg) {
        $html .= "<div class='package-box'>
            <h3>{$pkg["name"]}</h3>
            <p>{$pkg["description"]}</p><ul>";

        foreach ($pkg["products"] as $product) {
            $plan = $product["plans"][0];
            $html .= "<li><strong>Storage:</strong> {$product["storageLimitGB"]}{$product["storageUnit"]} |
                <strong>Price:</strong> {$plan["amount"]} {$plan["currency"]}/{$plan["interval"]}</li>";
        }

        $html .= "</ul></div>";
    }

    return $html . "</div>";
}
add_shortcode("packages_api", "get_packages_api_content");
